#version 330
#extension GL_EXT_gpu_shader4 : enable
// Pasta GraphMod01.fsh  by   mosaic

//https://www.shadertoy.com/view/WtSXRK
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels


#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize


//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// To merge all pasta layers in to one, comment out line 35
// To reverse the order of the pasta layers, replace line 30 with line 31

float csg_nand (float a, float b) {
    return -max(a,b);
}

// aka A AND NOT B, NOT(NAND(A,NOT(B)))
float csg_sub (float a, float b) {
    float o = csg_nand(a, csg_nand(b, b));
    return csg_nand(o, o);
}


mat2 rotate2d(float _angle){
    return mat2(cos(_angle),-sin(_angle),
                sin(_angle),cos(_angle));
}

float sdRoundBox( in vec2 p, in vec2 b, in float r ) 
{
    vec2 q = abs(p) - b;
    return   abs(min(max(q.x,q.y),0.0) + length(max(q,0.0)) - r)-r/3.;
}

float loop( in vec2 p, in vec2 b, in float r )
{
    float s = 0.0;
    
    for(float i = 1.0;i<30.0;i+=1.0)
    //for(float i = 30.0;i>1.0;i-=1.0)  // To reverse the order of the pasta layers, replace line above with this line   
        
    {
        float m=sdRoundBox(p*rotate2d(i*iTime/50.+iMouse.x/8000.*i),i*b,r);  
        s=min(s,m); // comment out this line to merge all layers in to one 
        s=csg_sub(s,m);
            }

    return s;
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
	vec2 p = (2.0*gl_FragCoord.xy-iResolution.xy)/iResolution.y;

	vec2 width_height = vec2(0.05,.05);// + 0.3*cos( iTime + vec2(0.0,1.57) + 0.0 );

	float d = loop( p, width_height, .1);

    vec3 col = vec3(1.0) -pow(d,.1);//*vec3(0.1,0.4,0.7);
    //vec3 col = vec3(1.0) - sign(d)*vec3(0.1,0.4,0.7);
	//col *= 1.0 - exp(-2.0*abs(d));
	//col *= 0.8 + 0.2*cos(120.0*d);
	//col = mix( col, vec3(1.0), 1.0-smoothstep(0.0,0.02,abs(d)) );

	//gl_FragColor = mix(vec4(col,1.0),vec4(.9,.8,.0,.0),.4);
    //gl_FragColor = (vec4(col,1.0))+ vec4(.2,.2,.0, 1.0);
      gl_FragColor = vec4(1.0)-(vec4(col,0.0))+vec4(.2,.2,.0,.0);
      gl_FragColor.a = length(gl_FragColor.rgb);
}